package ru.yandex.direct.core.entity.strategy.type.withlastbidderrestarttime

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithLastBidderRestartTime
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithLastBidderRestartTimeToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<StrategyWithLastBidderRestartTime> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithLastBidderRestartTime,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithLastBidderRestartTime,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithLastBidderRestartTime::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithLastBidderRestartTime) {
        strategyData.lastBidderRestartTime = strategy.lastBidderRestartTime
    }
}
