package ru.yandex.direct.core.entity.strategy.type.withlastbidderrestarttime

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithLastBidderRestartTime
import ru.yandex.direct.core.entity.strategy.service.update.AbstractStrategyUpdateOperationTypeSupport
import ru.yandex.direct.model.AppliedChanges
import java.time.LocalDateTime

@Component
class StrategyWithLastBidderRestartTimeUpdateTypeSupport :
    AbstractStrategyUpdateOperationTypeSupport<StrategyWithLastBidderRestartTime>() {

    override fun onAppliedChangesValidated(
        updateContainer: StrategyUpdateOperationContainer,
        appliedChanges: List<AppliedChanges<StrategyWithLastBidderRestartTime>>
    ) {
        appliedChanges
            .forEach { changes: AppliedChanges<StrategyWithLastBidderRestartTime> ->
                modifyLastBidderRestartTimeOfStrategyIfNeed(
                    updateContainer.now,
                    changes
                )
            }
    }

    private fun modifyLastBidderRestartTimeOfStrategyIfNeed(
        now: LocalDateTime,
        appliedChanges: AppliedChanges<StrategyWithLastBidderRestartTime>
    ) {
        val isStrategyWithSupportOfLearningStatus =
            StrategyWithLastBidderRestartTimeChangesUtils.isStrategyWithSupportOfLearningStatus(
                appliedChanges.model.type,
                appliedChanges.model.goalId
            )
        if (isStrategyWithSupportOfLearningStatus) {
            val isRestart = isConversionStrategyRestarting(appliedChanges)
            StrategyWithLastBidderRestartTimeChangesUtils.modifyLastBidderRestartTime(isRestart, now, appliedChanges)
        }
    }

    private fun isConversionStrategyRestarting(appliedChanges: AppliedChanges<StrategyWithLastBidderRestartTime>): Boolean {
        val isAttributionModelChanged = appliedChanges.changed(
            StrategyWithLastBidderRestartTime.ATTRIBUTION_MODEL
        )
        val isStrategyGoalIdChanged = appliedChanges.changed(StrategyWithConversion.GOAL_ID)
        val isChangedStrategyModel = StrategyWithLastBidderRestartTimeChangesUtils.isStrategyModelChanged(
            appliedChanges.getOldValue(StrategyWithLastBidderRestartTime.TYPE)!!,
            appliedChanges.getNewValue(StrategyWithLastBidderRestartTime.TYPE)!!
        )
        val isOldStrategyWithoutSupportOfLearningStatus =
            !StrategyWithLastBidderRestartTimeChangesUtils.isStrategyWithSupportOfLearningStatus(
                appliedChanges.getOldValue(StrategyWithLastBidderRestartTime.TYPE)!!,
                appliedChanges.getOldValue(StrategyWithLastBidderRestartTime.GOAL_ID)
            )
        return isAttributionModelChanged || isStrategyGoalIdChanged || isOldStrategyWithoutSupportOfLearningStatus || isChangedStrategyModel
    }

    override fun getTypeClass() = StrategyWithLastBidderRestartTime::class.java
}
