package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoals
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithMeaningfulGoalsConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithMeaningfulGoals> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithMeaningfulGoals,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        if (campaign is CampaignWithMeaningfulGoals) {
            strategy.withMeaningfulGoals(campaign.meaningfulGoals)
        }
    }

    override fun getTypeClass() = StrategyWithMeaningfulGoals::class.java
}
