package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.inSet
import ru.yandex.direct.validation.constraint.CommonConstraints.isNull
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.constraint.NumberConstraints.inRange
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

class MeaningfulGoalValidator(private val container: ValidationContainer) : Validator<MeaningfulGoal, Defect<*>> {

    override fun apply(t: MeaningfulGoal): ValidationResult<MeaningfulGoal, Defect<*>> {
        val vb = ModelItemValidationBuilder.of(t)
        val isCrrStrategy = container.strategyType == StrategyName.AUTOBUDGET_CRR
        vb.item(MeaningfulGoal.IS_METRIKA_SOURCE_OF_VALUE)
            .check(isNull(), When.isTrue(!isCrrStrategy || !container.allowMeaningfulGoalValueFromMetrika))

        vb.item(MeaningfulGoal.GOAL_ID)
            .check(notNull())
            .check(inSet(container.goalIds),
                When.isFalse(container.isCopy || container.allGoalsAreAvailable))
        vb.item(MeaningfulGoal.CONVERSION_VALUE)
            .check(notNull())
            .check(inRange(container.currency.minPrice, container.currency.maxAutobudget))

        return vb.result
    }

    companion object {
        data class ValidationContainer(val currency: Currency,
                                       val goalIds: Set<Long>,
                                       val allGoalsAreAvailable: Boolean,
                                       val allowMeaningfulGoalValueFromMetrika: Boolean,
                                       val strategyType: StrategyName,
                                       val isCopy: Boolean = false)
    }
}
