package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal
import ru.yandex.direct.core.entity.campaign.service.MeaningfulGoalUtils
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.service.add.AbstractStrategyAddOperationTypeSupport


@Component
class StrategyWithMeaningfulGoalsAddOperationSupport :
        AbstractStrategyAddOperationTypeSupport<StrategyWithMeaningfulGoals>() {

    override fun onPreValidated(addContainer: StrategyAddOperationContainer, models: List<StrategyWithMeaningfulGoals>) {
        models.forEach(this::removeDefaultGoals)
    }

    /**
     * Фронт может присылать дефолтную цель(ака Вовлеченные Сессии) без value. Её записывать в базу не следует.
     */
    private fun removeDefaultGoals(strategy: StrategyWithMeaningfulGoals) {
        if (strategy.meaningfulGoals != null) {
            val meaningfulGoalsWithoutDefault: List<MeaningfulGoal> = strategy.meaningfulGoals
                    .filterNot { MeaningfulGoalUtils.goalIsDefault(it) }
            strategy.meaningfulGoals = meaningfulGoalsWithoutDefault
        }
    }

    override fun getTypeClass() = StrategyWithMeaningfulGoals::class.java

}
