package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithMeaningfulGoalsAddValidationTypeSupport(
    private val validatorProvider: StrategyWithMeaningfulGoalsValidatorProvider
) : AbstractStrategyAddValidationTypeSupport<StrategyWithMeaningfulGoals>() {
    override fun getTypeClass(): Class<StrategyWithMeaningfulGoals> = StrategyWithMeaningfulGoals::class.java

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<StrategyWithMeaningfulGoals>, Defect<*>>
    ): ValidationResult<List<StrategyWithMeaningfulGoals>, Defect<*>> {
        val validator = validatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
