package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal;
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithMeaningfulGoalsRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithMeaningfulGoals> {

    @Autowired
    protected StrategyWithMeaningfulGoalsRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithMeaningfulGoals> createMapper() {
        return baseBuilder()
                .map(convertibleProperty(
                        StrategyWithMeaningfulGoals.MEANINGFUL_GOALS,
                        STRATEGIES.MEANINGFUL_GOALS,
                        CampaignConverter::meaningfulGoalsFromDb,
                        StrategyWithMeaningfulGoalsRepositoryTypeSupport::meaningfulGoalsToDb)
                ).build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<StrategyWithMeaningfulGoals> getTypeClass() {
        return StrategyWithMeaningfulGoals.class;
    }

    private static String meaningfulGoalsToDb(List<MeaningfulGoal> meaningfulGoals) {
        return CampaignConverter.meaningfulGoalsToDb(meaningfulGoals, true);
    }
}
