package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoals
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithMeaningfulGoalsToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<StrategyWithMeaningfulGoals> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithMeaningfulGoals,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        if (campaign is CampaignWithMeaningfulGoals) {
            campaign.meaningfulGoals = strategy.meaningfulGoals
        }
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithMeaningfulGoals,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        if (CampaignWithMeaningfulGoals::class.java.isAssignableFrom(campaignClass)) {
            modelChanges.castModel(CampaignWithMeaningfulGoals::class.java)
                .process(
                    strategy.meaningfulGoals,
                    CampaignWithMeaningfulGoals.MEANINGFUL_GOALS
                )
        }
    }

    override fun getTypeClass() = StrategyWithMeaningfulGoals::class.java
}
