package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.service.MeaningfulGoalUtils
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.service.update.AbstractStrategyUpdateOperationTypeSupport
import ru.yandex.direct.model.AppliedChanges

@Component
class StrategyWithMeaningfulGoalsUpdateOperationSupport :
    AbstractStrategyUpdateOperationTypeSupport<StrategyWithMeaningfulGoals>() {

    override fun onChangesApplied(container: StrategyUpdateOperationContainer,
                                  appliedChanges: List<AppliedChanges<StrategyWithMeaningfulGoals>>) {
        appliedChanges.forEach { removeDefaultGoals(it) }
    }

    /**
     * Фронт может присылать дефолтную цель(ака Вовлеченные Сессии) без value. Её записывать в базу не следует.
     */
    private fun removeDefaultGoals(strategyWithMeaningfulGoalsChanges: AppliedChanges<StrategyWithMeaningfulGoals>) {
        if (strategyWithMeaningfulGoalsChanges.model.meaningfulGoals == null) {
            return
        }
        val meaningfulGoalsWithoutDefault = strategyWithMeaningfulGoalsChanges.model.meaningfulGoals
            .filterNot { MeaningfulGoalUtils.goalIsDefault(it) }
        strategyWithMeaningfulGoalsChanges.model.meaningfulGoals = meaningfulGoalsWithoutDefault
    }

    override fun onAppliedChangesValidated(updateContainer: StrategyUpdateOperationContainer?,
                                           appliedChanges: List<AppliedChanges<StrategyWithMeaningfulGoals>>) {
        appliedChanges.forEach { removeMetrikaValueSource(it) }
    }

    /**
     * Если фронт изменил стратегию из ДРР. Метрика, как источник value для кц становится недоступной.
     * Чтобы в массовых изменениях стратегии, не ловить ошибку валидации -- сбрасываем флажок.
     */
    private fun removeMetrikaValueSource(
        strategyWithMeaningfulGoalsChanges: AppliedChanges<StrategyWithMeaningfulGoals>) {
        val model = strategyWithMeaningfulGoalsChanges.model
        if (model.meaningfulGoals == null) {
            return
        }
        if (model.type != StrategyName.AUTOBUDGET_CRR) {
            val meaningfulGoals = model.meaningfulGoals
                .map { it.withIsMetrikaSourceOfValue(null) }
            strategyWithMeaningfulGoalsChanges.model.meaningfulGoals = meaningfulGoals
        }
    }

    override fun getTypeClass() = StrategyWithMeaningfulGoals::class.java

}
