package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithMeaningfulGoalsUpdateValidationTypeSupport(
    private val validatorProvider: StrategyWithMeaningfulGoalsValidatorProvider
) : AbstractStrategyUpdateValidationTypeSupport<StrategyWithMeaningfulGoals>() {
    override fun getTypeClass(): Class<StrategyWithMeaningfulGoals> = StrategyWithMeaningfulGoals::class.java

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<List<StrategyWithMeaningfulGoals>, Defect<*>>
    ): ValidationResult<List<StrategyWithMeaningfulGoals>, Defect<*>> {
        val validator = validatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
