package ru.yandex.direct.core.entity.strategy.type.withmeaningfulgoals

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.service.validation.type.MobileContentServiceHelper
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent
import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.utils.StrategyModelUtils.goalId
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

@Component
class StrategyWithMeaningfulGoalsValidatorProvider(
    private val mobileContentServiceHelper: MobileContentServiceHelper
) : AbstractStrategyValidatorProvider<StrategyWithMeaningfulGoals>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<StrategyWithMeaningfulGoals, Defect<*>> =
        Validator { strategy: StrategyWithMeaningfulGoals ->
            val mobileContentProvider = MobileContentProvider(mobileContentServiceHelper, container.clientId)
            val validationContainer = MeaningfulGoalsValidator.Companion.ValidationContainer(
                container.currency,
                container.strategyGoals(strategy),
                container.availableFeatures,
                strategy.type,
                mobileContentProvider::mobileContents,
                container.options.isCopy,
                container.options.isRequestFromInternalNetwork,
                strategy.goalId(),
                container.options.isCampaignToPackageStrategyOneshot
            )
            val validator = MeaningfulGoalsValidator(validationContainer)

            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithMeaningfulGoals.MEANINGFUL_GOALS)
                .checkBy(validator)

            vb.result
        }

    internal class MobileContentProvider(
        private val mobileContentServiceHelper: MobileContentServiceHelper,
        private val clientId: ClientId,
    ) {

        fun mobileContents(mobileAppIds: Set<Long>): List<MobileContent> =
            mobileContentServiceHelper.getMobileContents(clientId, mobileAppIds)
    }
}
