package ru.yandex.direct.core.entity.strategy.type.withmetrikacounters

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.WithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithMetrikaCountersConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithMetrikaCounters> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithMetrikaCounters,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        if (campaign is WithMetrikaCounters && campaign.metrikaCounters != null) {
            strategy.withMetrikaCounters(campaign.metrikaCounters)
        } else {
            strategy.withMetrikaCounters(listOf())
        }
    }

    override fun getTypeClass() = StrategyWithMetrikaCounters::class.java
}
