package ru.yandex.direct.core.entity.strategy.type.withmetrikacounters

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithMetrikaCountersAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithMetrikaCounters>() {

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<StrategyWithMetrikaCounters>, Defect<*>>): ValidationResult<List<StrategyWithMetrikaCounters>, Defect<*>> {
        val validator = StrategyWithMetrikaCountersValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithMetrikaCounters> = StrategyWithMetrikaCounters::class.java

}
