package ru.yandex.direct.core.entity.strategy.type.withmetrikacounters

import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMetrikaCounters
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.WithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.utils.CollectionUtils.isEmpty

@Component
@ParametersAreNonnullByDefault
class StrategyWithMetrikaCountersToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<StrategyWithMetrikaCounters> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithMetrikaCounters,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        if (campaign is CampaignWithMetrikaCounters) campaign.metrikaCounters =
            if (strategy.metrikaCounters.isNullOrEmpty()) null else strategy.metrikaCounters
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithMetrikaCounters,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        if (CampaignWithMetrikaCounters::class.java.isAssignableFrom(campaignClass)) {
            modelChanges.castModel(CampaignWithMetrikaCounters::class.java)
                .process(
                    if (isEmpty(strategy.metrikaCounters)) null else strategy.metrikaCounters,
                    WithMetrikaCounters.METRIKA_COUNTERS
                )
        }
    }

    override fun getTypeClass() = StrategyWithMetrikaCounters::class.java
}
