package ru.yandex.direct.core.entity.strategy.type.withmetrikacounters

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithMetrikaCountersUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<StrategyWithMetrikaCounters>() {
    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<List<StrategyWithMetrikaCounters>, Defect<*>>): ValidationResult<List<StrategyWithMetrikaCounters>, Defect<*>> {
        val validator = StrategyWithMetrikaCountersValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithMetrikaCounters> = StrategyWithMetrikaCounters::class.java

}
