package ru.yandex.direct.core.entity.strategy.type.withpayforconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithPayForConversionConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithPayForConversion> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithPayForConversion,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withIsPayForConversionEnabled(campaign.strategy.strategyData.payForConversion)
    }

    override fun getTypeClass() = StrategyWithPayForConversion::class.java
}
