package ru.yandex.direct.core.entity.strategy.type.withpayforconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithPayForConversionAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithPayForConversion>() {

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<StrategyWithPayForConversion>, Defect<*>>): ValidationResult<List<StrategyWithPayForConversion>, Defect<*>> {
        val validator = StrategyWithPayForConversionValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithPayForConversion> = StrategyWithPayForConversion::class.java
}
