package ru.yandex.direct.core.entity.strategy.type.withpayforconversion;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithPayForConversionRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithPayForConversion> {

    protected StrategyWithPayForConversionRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithPayForConversion> createMapper() {
        return baseBuilder()
                .map(jsonBooleanToLong(
                        StrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED,
                        STRATEGIES.STRATEGY_DATA,
                        "pay_for_conversion"
                ))
                .build();
    }

    @Override
    public Class<StrategyWithPayForConversion> getTypeClass() {
        return StrategyWithPayForConversion.class;
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }
}
