package ru.yandex.direct.core.entity.strategy.type.withpayforconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithPayForConversionUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<StrategyWithPayForConversion>() {
    override fun getTypeClass(): Class<StrategyWithPayForConversion> = StrategyWithPayForConversion::class.java

    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<MutableList<StrategyWithPayForConversion>, Defect<*>>): ValidationResult<List<StrategyWithPayForConversion>, Defect<*>> {
        val validator = StrategyWithPayForConversionValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
