package ru.yandex.direct.core.entity.strategy.type.withpayforconversion

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithPayForConversionValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithPayForConversion>() {
    
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<StrategyWithPayForConversion, Defect<*>> =
        Validator { strategy: StrategyWithPayForConversion ->
            val validatorContainer = PayForConversionValidator.Companion.ValidationContainer(
                strategy.type,
                strategy.goalId,
                container.campaignType(strategy),
                container.availableFeatures,
                container.options.isValidatePayForConversionInAutobudgetAvgCpaPerFilter
            )
            val validator = PayForConversionValidator(validatorContainer)
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED)
                .checkBy(validator, When.notNull())

            vb.result
        }
}
