package ru.yandex.direct.core.entity.strategy.type.withweeklybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithWeeklyBudgetConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithWeeklyBudget> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithWeeklyBudget,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withSum(campaign.strategy.strategyData.sum)
    }

    override fun getTypeClass() = StrategyWithWeeklyBudget::class.java
}
