package ru.yandex.direct.core.entity.strategy.type.withweeklybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithWeeklyBudgetAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithWeeklyBudget>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<StrategyWithWeeklyBudget>, Defect<*>>
    ): ValidationResult<List<StrategyWithWeeklyBudget>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(StrategyWithWeeklyBudgetValidatorProvider.createAddStrategyValidator(container))
            .result

    override fun getTypeClass() = StrategyWithWeeklyBudget::class.java
}
