package ru.yandex.direct.core.entity.strategy.type.withweeklybudget;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithWeeklyBudgetRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithWeeklyBudget> {
    protected StrategyWithWeeklyBudgetRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithWeeklyBudget> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        StrategyWithWeeklyBudget.SUM,
                        STRATEGIES.STRATEGY_DATA,
                        "sum"
                ))
                .build();
    }

    @Override
    public Class<StrategyWithWeeklyBudget> getTypeClass() {
        return StrategyWithWeeklyBudget.class;
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }
}
