package ru.yandex.direct.core.entity.strategy.type.withweeklybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithWeeklyBudgetToCampaignConverterSupport :
    StrategyToCampaignConverterSupport<StrategyWithWeeklyBudget> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithWeeklyBudget,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithWeeklyBudget,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithWeeklyBudget::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithWeeklyBudget) {
        strategyData.sum = strategy.sum
    }
}
