package ru.yandex.direct.core.entity.strategy.type.withweeklybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithWeeklyBudgetUpdateValidationTypeSupport :
    AbstractStrategyUpdateValidationTypeSupport<StrategyWithWeeklyBudget>() {

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<MutableList<StrategyWithWeeklyBudget>, Defect<*>>
    ): ValidationResult<List<StrategyWithWeeklyBudget>, Defect<*>> {
        val validator = StrategyWithWeeklyBudgetValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithWeeklyBudget> = StrategyWithWeeklyBudget::class.java
}
