package ru.yandex.direct.core.entity.strategy.type.withweeklybudget

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithWeeklyBudgetValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithWeeklyBudget>() {
    private val typesRequired = setOf(
        StrategyName.AUTOBUDGET,
        StrategyName.AUTOBUDGET_MAX_REACH,
        StrategyName.AUTOBUDGET_MAX_IMPRESSIONS,
        StrategyName.AUTOBUDGET_AVG_CPV
    )

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        Validator { strategy: StrategyWithWeeklyBudget ->
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithWeeklyBudget.SUM)
                .checkBy(
                    SumValidator(container.currency, strategy.type),
                    When.isTrue(strategy.sum != null || typesRequired.contains(strategy.type))
                )
            vb.result
        }

}
