package ru.yandex.direct.core.entity.strategy.type.withweeklybudget

import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.NumberConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal

class SumValidator(currency: Currency, strategyType: StrategyName) : Validator<BigDecimal, Defect<*>> {

    companion object {
        private val WEEK_DAYS = BigDecimal.valueOf(7)
        private val CPM_STRATEGIES_WITH_SUM = setOf(
            StrategyName.AUTOBUDGET_MAX_REACH,
            StrategyName.AUTOBUDGET_MAX_IMPRESSIONS,
            StrategyName.AUTOBUDGET_AVG_CPV
        )
    }

    val minValue: BigDecimal = when {
        CPM_STRATEGIES_WITH_SUM.contains(strategyType) -> currency.minDailyBudgetForPeriod.multiply(WEEK_DAYS)
        else -> currency.minAutobudget
    }

    val maxValue: BigDecimal = currency.maxAutobudget

    override fun apply(value: BigDecimal?): ValidationResult<BigDecimal, Defect<*>> =
        ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(NumberConstraints.notLessThan(minValue))
            .check(NumberConstraints.notGreaterThan(maxValue))
            .result
}
