package ru.yandex.direct.core.entity.strategy.utils

import java.math.BigDecimal
import ru.yandex.direct.core.entity.campaign.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCampaignIds
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion

object StrategyModelUtils {

    fun BaseStrategy.campaignIds(): List<Long> =
        (this as? StrategyWithCampaignIds)?.cids ?: emptyList()

    @JvmStatic
    fun BaseStrategy.metrikaCounterIds(): Set<Long> =
        (this as? StrategyWithMetrikaCounters)?.metrikaCounters?.toSet() ?: emptySet()

    fun BaseStrategy.isPayForConversionEnabled(): Boolean =
        (this as? StrategyWithPayForConversion)?.isPayForConversionEnabled ?: false

    fun BaseStrategy.goalId(): Long? =
        (this as? StrategyWithConversion)?.goalId

    fun BaseStrategy.clientId(): Long? =
        (this as? CommonStrategy)?.clientId

    @JvmStatic
    fun toStrategyName(type: StrategyName): ru.yandex.direct.core.entity.strategy.model.StrategyName {
        return ru.yandex.direct.core.entity.strategy.model.StrategyName.valueOf(type.name)
    }

    fun BaseStrategy.avgCpm(): BigDecimal? =
        (this as? StrategyWithAvgCpm)?.avgCpm
}
