package ru.yandex.direct.core.entity.strategy.validation

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationOptionalTypeSpecificContainer
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

abstract class AbstractStrategyValidatorProvider<T : BaseStrategy> {

    open fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<T, Defect<*>> =
        Validator { strategy: T ->
            val vb = ModelItemValidationBuilder.of(strategy)
            vb.result
        }

    open fun createAddStrategyValidator(container: StrategyAddOperationContainer): Validator<T, Defect<*>> =
        createStrategyValidator(container)

    open fun createUpdateStrategyValidator(container: StrategyUpdateOperationContainer): Validator<T, Defect<*>> =
        createStrategyValidator(container)

    open fun createAddStrategyPreValidator(container: StrategyAddOperationContainer): Validator<T, Defect<*>> =
        Validator { strategy: T ->
            val vb = ModelItemValidationBuilder.of(strategy)
            vb.result
        }

    open fun createUpdateStrategyPreValidator(container: StrategyUpdateOperationContainer): Validator<ModelChanges<T>, Defect<*>> =
        Validator { strategy: ModelChanges<T> ->
            val vb = ModelChangesValidationBuilder.of(strategy)
            vb.result
        }

    open fun createUpdateStrategyBeforeApplyValidator(
        container: StrategyUpdateOperationContainer
    ): Validator<ModelChanges<T>, Defect<*>> =
        Validator { strategy: ModelChanges<T> ->
            val vb = ModelChangesValidationBuilder.of(strategy)
            vb.result
        }
}

abstract class AbstractStrategyValidatorProviderWithTypeSpecificContainer<T : BaseStrategy, C : StrategyUpdateOperationOptionalTypeSpecificContainer> :
    AbstractStrategyValidatorProvider<T>() {
    open fun createUpdateStrategyBeforeApplyValidator(
        container: StrategyUpdateOperationContainer,
        typeSpecificContainer: C
    ) = super.createUpdateStrategyBeforeApplyValidator(container)
}
