package ru.yandex.direct.core.entity.strategy.validation

import ru.yandex.direct.core.entity.campaign.model.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.model.ModelProperty
import ru.yandex.direct.utils.NumberUtils

object StrategyValidationUtils {

    fun campaignTypeNullOr(campaignType: CampaignType?, expectedCampaignType: CampaignType): Boolean =
        campaignTypeNullOr(campaignType) { it == expectedCampaignType }

    fun campaignTypeNullOr(campaignType: CampaignType?, expectedCampaignTypes: Set<CampaignType>): Boolean =
        campaignTypeNullOr(campaignType) { expectedCampaignTypes.contains(it) }

    fun campaignTypeNotNullAnd(campaignType: CampaignType?, expectedCampaignTypes: Set<CampaignType>): Boolean =
        campaignTypeNotNullAnd(campaignType) { expectedCampaignTypes.contains(it) }

    /*
    * По сути при валидации стратегии не заданный campaignType значит, что у нас campaignType == *.
    * И следовательно считаем в этом случае, что это любой тип кампании.
    * */
    fun campaignTypeNullOr(campaignType: CampaignType?, predicate: (CampaignType) -> Boolean): Boolean =
        campaignType?.let(predicate) ?: true

    /*
    * По сути при валидации стратегии не заданный campaignType значит, что у нас campaignType == *.
    * И следовательно считаем в этом случае, что это любой тип кампании.
    * Данный метод - аналог campaignTypeNullOr, но для проверки по black-листам
    * */
    fun campaignTypeNotNullAnd(campaignType: CampaignType?, predicate: (CampaignType) -> Boolean): Boolean =
        campaignType?.let(predicate) ?: false

    fun isWalletHasDayBudget(wallet: Campaign?): Boolean =
        wallet != null && NumberUtils.greaterThanZero(wallet.dayBudget)

    fun <M : BaseStrategy, V> getStrategyPropIfChangedOrDefault(
        modelChanges: ModelChanges<M>,
        prop: ModelProperty<in M, V?>,
        defaultValue: V
    ): V? = if (modelChanges.isPropChanged(prop)) modelChanges.getChangedProp(prop) else defaultValue
}
