package ru.yandex.direct.core.entity.strategy.validation.update;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy;
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa;
import ru.yandex.direct.multitype.service.validation.type.update.UpdateValidationTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class StrategyUpdateValidationTypeSupportFacade
        extends UpdateValidationTypeSupportFacade<BaseStrategy, StrategyUpdateOperationContainer> {

    @Autowired
    public StrategyUpdateValidationTypeSupportFacade(
            List<StrategyUpdateValidationTypeSupport<? extends BaseStrategy>> supports) {
        super(supports, Set.of(StrategyWithAvgCpa.class, CommonStrategy.class));
    }

}
