package ru.yandex.direct.core.entity.strategy.validation.validators

import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.NumberConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal

class AvgBidValidator(
    private val currency: Currency,
    private val sum: BigDecimal?,
    private val bid: BigDecimal?,
    campaignsType: CampaignType?,
    private val strategyType: StrategyName? = null
) : Validator<BigDecimal, Defect<*>> {

    private val minValue: BigDecimal = when (campaignsType) {
        CampaignType.PERFORMANCE -> currency.minCpcCpaPerformance
        else -> currency.minAutobudgetAvgPrice
    }

    override fun apply(value: BigDecimal?): ValidationResult<BigDecimal, Defect<*>> =
        ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(NumberConstraints.notLessThan(minValue))
            .check(NumberConstraints.notGreaterThan(currency.maxAutobudgetBid))
            .check(
                NumberConstraints.notGreaterThan(sum),
                StrategyDefects.weekBudgetLessThan(),
                When.isTrue(sum != null)
            ).check(
                NumberConstraints.notGreaterThan(bid),
                StrategyDefects.bidLessThanAvgBid(),
                When.isTrue(bid != null && strategyType != StrategyName.AUTOBUDGET_WEEK_BUNDLE)
            ).check(
                CommonConstraints.isNull(),
                StrategyDefects.avgBidAndBidTogetherAreProhibited(),
                When.isTrue(bid != null && strategyType == StrategyName.AUTOBUDGET_WEEK_BUNDLE)
            )
            .result

}
