package ru.yandex.direct.core.entity.takeout.model;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Объект для сохранения стейта джобы
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ProcessedData {
    /**
     * Полностью залитые clientId (все кампании), актуально для агентств
     */
    @JsonProperty("clients")
    private Set<Long> clients = new HashSet<>();
    /**
     * Залитые кампании
     */
    @JsonProperty("campaign_ids")
    private Set<Long> campaignIds = new HashSet<>();
    /**
     * Токен, на котором остановилась выгрузка user action логов, см UserActionLogOffset
     */
    @JsonProperty("user_action_logs_token")
    private String userActionLogsToken;
    /**
     * Залиты ли все пользлоги
     */
    @JsonProperty("user_action_logs")
    private boolean userActionLogs = false;
    /**
     * Залиты ли настройки пользователя
     */
    @JsonProperty("user_settings")
    private boolean userSettings = false;
    /**
     * Доступна ли выгрузка данных на clientId(сейчас только для Европы)
     */
    @JsonProperty("region_accepted")
    private boolean regionAccepted = false;
    /**
     * Отправленные в takeout файлы
     */
    @JsonProperty("uploaded_files")
    private Set<String> uploadedFiles = new HashSet<>();
    /**
     * Залиты ли фиды
     */
    @JsonProperty("feeds")
    private boolean feeds = false;

    public void addCampaignId(Long campaignId) {
        campaignIds.add(campaignId);
    }

    public void addClientId(Long clientId) {
        clients.add(clientId);
    }

    public void setUserSettings(boolean flag) {
        userSettings = flag;
    }

    public void setUserActionLogsToken(String token) {
        userActionLogsToken = token;
    }

    public boolean getUserActionLogs() {
        return userActionLogs;
    }

    public void setUserActionLogs(boolean flag) {
        this.userActionLogs = flag;
    }

    public Set<Long> getClients() {
        return clients;
    }

    public Set<Long> getCampaignIds() {
        return campaignIds;
    }

    public String getUserActionLogsToken() {
        return userActionLogsToken;
    }

    public boolean getUserSettings() {
        return userSettings;
    }

    public boolean isRegionAccepted() {
        return regionAccepted;
    }

    public void setRegionAccepted(boolean regionAccepted) {
        this.regionAccepted = regionAccepted;
    }

    public void addUploadedFile(File file) {
        uploadedFiles.add(file.getName());
    }

    public Set<String> getUploadedFiles() {
        return uploadedFiles;
    }

    public boolean feeds() {
        return feeds;
    }

    public void setFeeds(boolean feeds) {
        this.feeds = feeds;
    }
}
