package ru.yandex.direct.core.entity.takeout.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TakeoutJobResult {
    @JsonProperty("error")
    private String error;
    @JsonProperty("files_uploaded")
    private Integer filesUploaded;

    @JsonCreator
    public TakeoutJobResult(
            @JsonProperty("files_uploaded") Integer filesUploaded,
            @Nullable @JsonProperty("error") String error) {
        this.filesUploaded = filesUploaded;
        this.error = error;
    }

    public static TakeoutJobResult error(ProcessedData processedData, String stacktrace) {
        return new TakeoutJobResult(processedData.getUploadedFiles().size(), stacktrace);
    }

    public static TakeoutJobResult success(ProcessedData processedData) {
        return new TakeoutJobResult(processedData.getUploadedFiles().size(), null);
    }

    @SuppressWarnings("unused")
    public String getError() {
        return error;
    }

    @SuppressWarnings("unused")
    public Integer getFilesUploaded() {
        return filesUploaded;
    }
}
