package ru.yandex.direct.core.entity.tax.model;

import java.time.LocalDate;
import java.util.Objects;

import ru.yandex.direct.currency.Percent;

public class TaxInfo {

    private final Long taxId;
    private final LocalDate startDate;
    private final Percent percent;

    public TaxInfo(Long taxId, LocalDate startDate, Percent percent) {
        this.taxId = taxId;
        this.startDate = startDate;
        this.percent = percent;
    }

    public Long getTaxId() {
        return taxId;
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public Percent getPercent() {
        return percent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaxInfo taxInfo = (TaxInfo) o;
        return Objects.equals(taxId, taxInfo.taxId) &&
                Objects.equals(startDate, taxInfo.startDate) &&
                Objects.equals(percent, taxInfo.percent);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taxId, startDate, percent);
    }
}
