package ru.yandex.direct.core.entity.tax.service;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.tax.model.TaxInfo;

@ParametersAreNonnullByDefault
public class TaxHistoryUtils {
    private TaxHistoryUtils() {
    }

    /**
     * Получаем информацию о налоге для присланного дня.
     *
     * @param day   день для которого нужно найти налог
     * @param taxes содержит информацию о налоге и с какого дня он действует
     */
    public static TaxInfo getTaxInfoForDay(LocalDate day, List<TaxInfo> taxes) {
        return StreamEx.of(taxes)
                .remove(tax -> tax.getStartDate().isAfter(day))
                .max(Comparator.comparing(TaxInfo::getStartDate))
                .orElseThrow();
    }
}
