package ru.yandex.direct.core.entity.timetarget.model;

import java.time.LocalDate;
import java.util.Objects;

import javax.annotation.Nullable;

/**
 * Представляет строчку в таблице {@code PPCDICT.GREAT_HOLIDAYS}
 */
public class HolidayItem {
    private final long regionId;
    private final LocalDate date;
    private final Type type;

    public HolidayItem(long regionId, LocalDate date, Type type) {
        this.date = date;
        this.regionId = regionId;
        this.type = type;
    }

    public long getRegionId() {
        return regionId;
    }

    @Nullable
    public LocalDate getDate() {
        return date;
    }

    public Type getType() {
        return type;
    }

    public enum Type {
        HOLIDAY,
        WORKDAY
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HolidayItem that = (HolidayItem) o;
        return regionId == that.regionId &&
                Objects.equals(date, that.date) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(regionId, date, type);
    }
}
