package ru.yandex.direct.core.entity.turbolanding.model;

import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import one.util.streamex.StreamEx;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class TurboLandingMetrikaCountersAndGoals {

    private List<TurboLandingMetrikaCounterWithGoals> countersWithGoals;

    public TurboLandingMetrikaCountersAndGoals(String jsonMetrikaCounters) {
        checkArgument(jsonMetrikaCounters != null, "jsonMetricaCounters should not be null");
        this.countersWithGoals = fromJson(
                jsonMetrikaCounters,
                new ObjectMapper().getTypeFactory()
                        .constructCollectionType(List.class, TurboLandingMetrikaCounterWithGoals.class)
        );
    }

    public List<TurboLandingMetrikaCounterWithGoals> getCountersWithGoals() {
        return countersWithGoals;
    }

    /**
     * @return List<Long> - уникальный набор счетчиков турболендинга
     */

    public List<Long> getAllMetrikaCounters() {
        return StreamEx.of(this.countersWithGoals).map(TurboLandingMetrikaCounter::getId).distinct().toList();
    }

    /**
     * @return List<Long> - уникальный набор целей, собранный по всем счетчикам турболендинга
     */

    public List<Long> getAllMetrikaGoals() {
        return this.countersWithGoals.stream()
                .flatMap(c -> c.getGoals().stream())
                .distinct()
                .collect(Collectors.toList());
    }

}
