package ru.yandex.direct.core.entity.turbolanding.model;

import java.util.Objects;

import ru.yandex.direct.model.Model;

public class TurboLandingWithBidAndCid implements Model {
    private Long bid;
    private Long cid;
    private Long turboLandingId;
    private TurboLandingMetrikaCountersAndGoals metrikaCounters;

    public TurboLandingWithBidAndCid(Long bid, Long cid, Long turboLandingId, String metrikaCounters) {
        this.bid = bid;
        this.cid = cid;
        this.turboLandingId = turboLandingId;
        this.metrikaCounters = new TurboLandingMetrikaCountersAndGoals(metrikaCounters);
    }

    public Long getBid() {
        return bid;
    }

    public Long getCid() {
        return cid;
    }

    public Long getTurboLandingId() {
        return turboLandingId;
    }

    public TurboLandingMetrikaCountersAndGoals getMetrikaCounters() {
        return metrikaCounters;
    }

    /*
        Эта модель используется для обработки привязанных к баннерам турболендингов.
        Счетчики и цели турболендинга при привязке/отвязке от баннера не меняются,
        поэтому заполненность и значение metrikaCounters на результаты сравнения не влияет.
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TurboLandingWithBidAndCid that = (TurboLandingWithBidAndCid) o;
        return Objects.equals(bid, that.bid) &&
                Objects.equals(cid, that.cid) &&
                Objects.equals(turboLandingId, that.turboLandingId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bid, cid, turboLandingId);
    }
}
