package ru.yandex.direct.core.entity.turbolanding.model;

import java.util.Set;

import ru.yandex.direct.model.ModelProperty;

public class TurboLandingWithCountersAndGoals extends TurboLanding {
    public static final ModelProperty<TurboLandingWithCountersAndGoals, Set<TurboLandingMetrikaCounter>> COUNTERS =
            ModelProperty.create(TurboLandingWithCountersAndGoals.class,
                    "counters",
                    TurboLandingWithCountersAndGoals::getCounters,
                    TurboLandingWithCountersAndGoals::setCounters);

    public static final ModelProperty<TurboLandingWithCountersAndGoals, Set<TurboLandingMetrikaGoal>> GOALS =
            ModelProperty.create(TurboLandingWithCountersAndGoals.class,
                    "goals",
                    TurboLandingWithCountersAndGoals::getGoals,
                    TurboLandingWithCountersAndGoals::setGoals);

    private Set<TurboLandingMetrikaCounter> counters;
    private Set<TurboLandingMetrikaGoal> goals;

    public TurboLandingWithCountersAndGoals()  {
    }

    public TurboLandingWithCountersAndGoals(TurboLanding turboLanding) {
        this.setId(turboLanding.getId());
        this.setClientId(turboLanding.getClientId());
        this.setName(turboLanding.getName());
        this.setUrl(turboLanding.getUrl());
        this.setIsChanged(turboLanding.getIsChanged());
        this.setLastModeratedVersion(turboLanding.getLastModeratedVersion());
        this.setPreset(turboLanding.getPreset());
        this.setPreviewHref(turboLanding.getPreviewHref());
        this.setTurboSiteHref(turboLanding.getTurboSiteHref());
        this.setStatusPostModerate(turboLanding.getStatusPostModerate());
        this.setVersion(turboLanding.getVersion());
        this.setIsCpaModerationRequired(turboLanding.getIsCpaModerationRequired());
        this.setStatusModerateForCpa(turboLanding.getStatusModerateForCpa());
        //metrikaCounters - deprecated поле, должно быть полностью удалено в ближайшее время
        //поэтому не копируем
        this.setMetrikaCounters("{}");
    }

    public Set<TurboLandingMetrikaCounter> getCounters() {
        return counters;
    }

    public void setCounters(Set<TurboLandingMetrikaCounter> counters) {
        this.counters = counters;
    }

    public TurboLandingWithCountersAndGoals withCounters(Set<TurboLandingMetrikaCounter> counters) {
        this.counters = counters;
        return this;
    }

    public Set<TurboLandingMetrikaGoal> getGoals() {
        return goals;
    }

    public void setGoals(Set<TurboLandingMetrikaGoal> goals) {
        this.goals = goals;
    }

    public TurboLandingWithCountersAndGoals withGoals(Set<TurboLandingMetrikaGoal> goals) {
        this.goals = goals;
        return this;
    }
}
