package ru.yandex.direct.core.entity.turbolanding.repository.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.turbolanding.model.TurboLandingMetrikaCounterContainer;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLandingMetrikaGoalContainer;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.tables.TurbolandingMetrikaCounters.TURBOLANDING_METRIKA_COUNTERS;
import static ru.yandex.direct.dbschema.ppc.tables.TurbolandingMetrikaGoals.TURBOLANDING_METRIKA_GOALS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
public class TurboLandingMetrikaCounterMapperProvider {

    private static final JooqMapperWithSupplier<TurboLandingMetrikaCounterContainer> COUNTER_MAPPER =
            createCounterMapper();
    private static final JooqMapperWithSupplier<TurboLandingMetrikaGoalContainer> GOAL_MAPPER =
            createGoalMapper();

    private TurboLandingMetrikaCounterMapperProvider() {
    }

    public static JooqMapperWithSupplier<TurboLandingMetrikaCounterContainer> getTurboLandingMetrikaCounterMapper() {
        return COUNTER_MAPPER;
    }

    public static JooqMapperWithSupplier<TurboLandingMetrikaGoalContainer> getTurboLandingMetrikaGoalMapper() {
        return GOAL_MAPPER;
    }

    private static JooqMapperWithSupplier<TurboLandingMetrikaCounterContainer> createCounterMapper() {
        return JooqMapperWithSupplierBuilder.builder(TurboLandingMetrikaCounterContainer::new)
                .map(property(TurboLandingMetrikaCounterContainer.TURBOLANDING_ID,
                        TURBOLANDING_METRIKA_COUNTERS.TL_ID))
                .map(property(TurboLandingMetrikaCounterContainer.COUNTER_ID,
                        TURBOLANDING_METRIKA_COUNTERS.COUNTER))
                .map(booleanProperty(TurboLandingMetrikaCounterContainer.IS_USER_COUNTER,
                        TURBOLANDING_METRIKA_COUNTERS.IS_USER_COUNTER))
                .build();
    }

    private static JooqMapperWithSupplier<TurboLandingMetrikaGoalContainer> createGoalMapper() {
        return JooqMapperWithSupplierBuilder.builder(TurboLandingMetrikaGoalContainer::new)
                .map(property(TurboLandingMetrikaGoalContainer.TURBOLANDING_ID,
                        TURBOLANDING_METRIKA_GOALS.TL_ID))
                .map(property(TurboLandingMetrikaGoalContainer.GOAL_ID,
                        TURBOLANDING_METRIKA_GOALS.GOAL_ID))
                .map(booleanProperty(TurboLandingMetrikaGoalContainer.IS_CONVERSION_GOAL,
                        TURBOLANDING_METRIKA_GOALS.IS_CONVERSION_GOAL))
                .build();
    }
}
