package ru.yandex.direct.core.entity.uac

import org.springframework.context.i18n.LocaleContextHolder
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.i18n.Language

private val DEFAULT_LANGUAGE = Language.RU

fun isValidId(id: String): Boolean {
    return try {
        id.toIdLong()
        true
    } catch (e: IllegalArgumentException) {
        false
    }
}

fun getCurrentLanguage(): Language =
    try {
        Language.fromLocale(LocaleContextHolder.getLocale())
    } catch (e: RuntimeException) {
        DEFAULT_LANGUAGE
    }

fun <T> Set<T>.appendIf(value: T, condition: Boolean): Set<T> {
    if (condition) {
        return this + setOf(value)
    }
    return this
}
