package ru.yandex.direct.core.entity.uac.converter

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest

object GroupRetargetingConditionConverter {
    fun toGroupRetargetingCondition(
        groupid: Long,
        retargetingCondition: RetargetingCondition?,
        existedRetargetingConditions: Map<Long, List<RetargetingCondition>>,
        existedTargetInterests: Map<Long, List<TargetInterest>>,
    ) : RetargetingCondition? {
        //Изначально объект создавался в UacRetargetingService.toCoreRetargetingCondition
        val retCondId: Long? = existedRetargetingConditions[groupid]?.get(0)?.id
        retargetingCondition?.let {
            return (RetargetingCondition()
                .withId(retCondId)
                .withName(retargetingCondition.name)
                .withType(retargetingCondition.type)
                .withClientId(retargetingCondition.clientId)
                .withTargetInterest(existedTargetInterests[retCondId]?.get(0))
                .withRules(retargetingCondition.rules) as RetargetingCondition)
        }
        return retargetingCondition
    }
}
