package ru.yandex.direct.core.entity.uac.converter

import org.slf4j.LoggerFactory
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform
import ru.yandex.direct.core.entity.uac.model.CampaignStatuses
import ru.yandex.direct.core.entity.uac.model.Status
import ru.yandex.direct.core.entity.uac.model.TargetStatus
import ru.yandex.direct.core.entity.uac.model.UacStrategyPlatform
import ru.yandex.direct.core.entity.uac.service.CampaignState
import ru.yandex.direct.core.entity.uac.service.ModerationState
import ru.yandex.direct.core.entity.uac.service.UacCampaignStates

object UacCampaignConverter {
    private val logger = LoggerFactory.getLogger(UacCampaignConverter::class.java)

    fun UacCampaignStates.toCampaignStatuses(isDraft: Boolean): CampaignStatuses {
        val status = toStatus(this, isDraft)
        val targetStatus = toTargetStatus(this, isDraft)
        return CampaignStatuses(status, targetStatus, campaignStateReasons, isCampaignAggrStatusObsolete)
    }

    @JvmStatic
    fun toCampaignsPlatform(strategyPlatform: UacStrategyPlatform?): CampaignsPlatform {
        return when (strategyPlatform) {
            UacStrategyPlatform.SEARCH -> CampaignsPlatform.SEARCH
            UacStrategyPlatform.CONTEXT -> CampaignsPlatform.CONTEXT
            else -> CampaignsPlatform.BOTH
        }
    }

    private fun toStatus(states: UacCampaignStates, isDraft: Boolean): Status {
        if (isDraft) {
            return Status.DRAFT
        }
        if (states.campaignState == CampaignState.DRAFT) {
            return if (states.campaignStatusShow == false) {
                Status.STOPPED
            } else {
                Status.MODERATING
            }
        }


        if (states.campaignState == CampaignState.OFF) {
            val reasons = states.campaignStateReasons ?: emptyList()

            if (states.moderationState == ModerationState.MODERATION
                    && !reasons.contains(GdSelfStatusReason.CAMPAIGN_SUSPENDED_BY_USER)) {
                return Status.MODERATING
            }

            return Status.STOPPED
        }
        /*if (states.campaignState in setOf(
                CampaignState.STOP_CRIT, CampaignState.STOP_WARN, CampaignState.OFF,
                CampaignState.PAUSE_CRIT, CampaignState.PAUSE_WARN, CampaignState.SUSPENDED
        )) {
            return Status.STOPPED
        }
        */

        if (states.campaignState == CampaignState.MODERATION) {
            return Status.MODERATING
        }
        if (states.campaignState == CampaignState.ARCHIVED) {
            return Status.ARCHIVED
        }
        if (states.moderationState == ModerationState.REJECTED) {
            // У отклоненной кампании могут быть активные подлежащие кампании,
            // в таком случае ее статус должен быть RUN_WARN.
            if (states.campaignState == CampaignState.RUN_WARN) {
                logger.info("campaign state: $states; returns ${Status.STARTED}")
                return Status.STARTED
            }
            return Status.REJECTED
        }
        if (states.moderationState == ModerationState.ACCEPTED) {
            if (states.campaignState == CampaignState.ON || states.campaignState == CampaignState.RUN_WARN) {
                return Status.STARTED
            }
            // Если все неархивные баннеры отклонены и есть архивные баннеры -
            // кампания может иметь statusModerate == Yes
            // Поэтому, чтобы не вернуть статус stopped, нужно еще проверить причину
            if (states.campaignStateReasons?.contains(
                    GdSelfStatusReason.CAMPAIGN_HAS_NO_ADS_ELIGIBLE_FOR_SERVING) == true) {
                return Status.REJECTED
            }
            logger.info("campaign state: $states; returns ${Status.STOPPED}")
            return Status.STOPPED
        }
        logger.info("campaign state: $states; returns ${Status.MODERATING}")
        return Status.MODERATING
    }

    private fun toTargetStatus(states: UacCampaignStates, isDraft: Boolean): TargetStatus {
        if (isDraft) {
            return TargetStatus.STOPPED
        }
        if (states.campaignState == CampaignState.DRAFT && states.campaignStatusShow == false) {
            return TargetStatus.STOPPED
        }
        if (states.campaignState != CampaignState.OFF && states.campaignState != CampaignState.ARCHIVED) {
            return TargetStatus.STARTED
        }
        return TargetStatus.STOPPED
    }
}
