package ru.yandex.direct.core.entity.uac.converter

import ru.yandex.direct.core.entity.uac.model.CampaignContentStatus
import ru.yandex.direct.core.entity.uac.model.Content
import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.model.Sitelink
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaignContent

object UacContentConverter {

    fun toCampaignContents(campaignId: String, contents: Collection<Content>): List<UacYdbCampaignContent> {
        return contents.mapIndexed { index, content ->
            UacYdbCampaignContent(
                campaignId = campaignId,
                contentId = content.id,
                type = content.type,
                order = index,
                status = CampaignContentStatus.CREATED,
            )
        }
    }

    fun toCampaignTextContents(
        campaignId: String,
        texts: Collection<String>?,
        mediaType: MediaType
    ): List<UacYdbCampaignContent> {
        return texts.orEmpty().mapIndexed { index, text ->
            UacYdbCampaignContent(
                campaignId = campaignId,
                text = text,
                type = mediaType,
                order = index,
                status = CampaignContentStatus.CREATED,
            )
        }
    }

    fun toCampaignSitelinkContent(
        campaignId: String,
        sitelinks: List<Sitelink>?
    ): List<UacYdbCampaignContent> {
        if (sitelinks == null) {
            return emptyList()
        }
        return sitelinks.mapIndexed { index, sitelink ->
            UacYdbCampaignContent(
                campaignId = campaignId,
                sitelink = sitelink,
                type = MediaType.SITELINK,
                order = index,
                status = CampaignContentStatus.CREATED,
            )
        }
    }

    fun toSitelink(campaignContent: UacYdbCampaignContent): Sitelink {
        check(campaignContent.type == MediaType.SITELINK && campaignContent.sitelink != null)

        val sitelink = campaignContent.sitelink
        return Sitelink(
            title = sitelink.title,
            href = sitelink.href,
            description = sitelink.description,
        )
    }
}
