package ru.yandex.direct.core.entity.uac.converter

import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toCpmAsset
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toDeviceTypes
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toRelevanceMatch
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toRetargetingCondition
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toShowsFrequencyLimit
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toSocdem
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toUacAdjustment
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toUacBrandSafety
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toUacDisabledPlaces
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.model.request.UacAdGroupBrief
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdString
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCampaignMeasurer
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCampaignMeasurerSystem
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaignContent
import ru.yandex.direct.core.grut.api.AdGroupBriefGrutModel
import ru.yandex.grut.objects.proto.client.Schema

object UacGrutAdGroupBriefConverter {
    fun toAdGroupBriefGrutModel(
        campaignId: Long,
        uacYdbCampaign: UacYdbCampaign,
        id: Long? = null,
        adGroupIds: List<Long>? = null,
        assetLinks: List<UacYdbCampaignContent>? = null,
    ) = AdGroupBriefGrutModel(
        id = id,
        campaignId = campaignId,
        url = uacYdbCampaign.storeUrl,
        regions = uacYdbCampaign.regions,
        minusRegions = uacYdbCampaign.minusRegions,
        hyperGeoId = uacYdbCampaign.hyperGeoId,
        keywords = uacYdbCampaign.keywords,
        minusKeywords = uacYdbCampaign.minusKeywords,
        socdem = uacYdbCampaign.socdem,
        deviceTypes = uacYdbCampaign.deviceTypes,
        retargetingCondition = uacYdbCampaign.retargetingCondition,
        videosAreNonSkippable = uacYdbCampaign.videosAreNonSkippable,
        brandSurveyId = uacYdbCampaign.brandSurveyId,
        showsFrequencyLimit = uacYdbCampaign.showsFrequencyLimit,
        cpmAssets = uacYdbCampaign.cpmAssets,
        adjustments = uacYdbCampaign.adjustments,
        campaignMeasurers = uacYdbCampaign.campaignMeasurers,
        uacBrandsafety = uacYdbCampaign.uacBrandsafety,
        uacDisabledPlaces = uacYdbCampaign.uacDisabledPlaces,
        relevanceMatch = uacYdbCampaign.relevanceMatch,
        assetLinks = assetLinks ?: uacYdbCampaign.assetLinks,
        adGroupIds = adGroupIds ?: listOf(),
        isCpmBrief = uacYdbCampaign.advType == AdvType.CPM_BANNER,
    )
}

fun Schema.TAdGroupBrief.toUacAdGroupBrief(): AdGroupBriefGrutModel {
    return getUacAdGroupBriefGrutModel(this)
}

private fun getUacAdGroupBriefGrutModel(
    tAdGroupBrief: Schema.TAdGroupBrief,
): AdGroupBriefGrutModel {
    val meta = tAdGroupBrief.meta
    val spec = tAdGroupBrief.spec
    val status = if (tAdGroupBrief.hasStatus()) tAdGroupBrief.status else null

    // Возможно костыльное решение и нужно поддержать честный тип заявки
    // https://st.yandex-team.ru/DIRECT-173973
    val isCpmBrief = spec.cpmData.cpmAssetsMap.isNotEmpty()
    return AdGroupBriefGrutModel(
        id = meta.id,
        campaignId = meta.campaignId,
        name = if (spec.hasName()) spec.name else null,
        url = if (spec.hasUrl()) spec.url else null,
        regions = spec.regionsList ?: emptyList(),
        hyperGeoId = if (spec.hasHypergeoId()) spec.hypergeoId else null,
        minusRegions = if (spec.minusRegionsCount > 0) spec.minusRegionsList else null,
        adjustments = if (spec.adjustmentsCount > 0) spec.adjustmentsList.map { it.toUacAdjustment() } else null,
        keywords = if (spec.keywordsCount > 0) spec.keywordsList else null,
        minusKeywords = if (spec.minusKeywordsCount > 0) spec.minusKeywordsList else null,
        socdem = if (spec.hasSocdem()) spec.socdem.toSocdem() else null,
        deviceTypes = if (spec.deviceTypeCount > 0) {
            spec.deviceTypeList.toDeviceTypes()
        } else {
            UacGrutCampaignConverter.getDefaultDeviceTypes(isCpmBrief)
        },
        videosAreNonSkippable = if (spec.hasVideosAreNonSkippable()) spec.videosAreNonSkippable else null,
        catalogIds = if (spec.catalogIdsCount > 0) spec.catalogIdsList else null,
        brandSurveyId = if (spec.cpmData.hasBrandSurveyId()) spec.cpmData.brandSurveyId else null,
        showsFrequencyLimit = if (spec.cpmData.hasShowsFrequencyLimit()) {
            spec.cpmData.showsFrequencyLimit.toShowsFrequencyLimit()
        } else {
            null
        },

        cpmAssets = if (spec.cpmData.cpmAssetsMap.isNotEmpty()) {
            spec.cpmData.cpmAssetsMap.mapValues { it.value.toCpmAsset() }
        } else {
            null
        },
        campaignMeasurers = if (spec.cpmData.campaignMeasurersList.isNotEmpty()) {
            spec.cpmData.campaignMeasurersList.map {
                UacCampaignMeasurer(
                    UacCampaignMeasurerSystem.valueOf(it.measurerType),
                    it.params
                )
            }
        } else {
            null
        },
        uacBrandsafety = if (spec.cpmData.hasBrandSafety()) {
            spec.cpmData.brandSafety?.toUacBrandSafety()
        } else {
            null
        },
        uacDisabledPlaces = if (spec.cpmData.hasDisabledPlaces()) {
            spec.cpmData.disabledPlaces?.toUacDisabledPlaces()
        } else if (spec.hasDisabledPlaces()) {
            spec.disabledPlaces?.toUacDisabledPlaces()
        } else {
            null
        },
        relevanceMatch = if (spec.hasRelevanceMatch()) {
            spec.relevanceMatch.toRelevanceMatch()
        } else {
            null
        },
        retargetingCondition = if (spec.cpmData.hasRetargetingCondition()) {
            spec.cpmData.retargetingCondition.toRetargetingCondition()
        } else if (spec.hasRetargetingCondition()) {
            spec.retargetingCondition.toRetargetingCondition()
        } else {
            null
        },
        assetLinks = UacGrutCampaignConverter.readAssetLinks(
            spec.briefAssetLinks,
            spec.briefAssetLinksStatuses,
            meta.campaignId.toIdString()
        ),
        adGroupIds = status?.adGroupIdsList,
        isCpmBrief = isCpmBrief,
    )
}

fun UacAdGroupBrief.toAdGroupBriefGrutModel() = AdGroupBriefGrutModel(
    id = this.adGroupBriefId,
    campaignId = this.campaignId.toIdLong(),
    name = this.name,
    url = this.url,
    regions = this.regions,
    hyperGeoId = this.hyperGeoId,
    minusRegions = this.minusRegions,
    adjustments = this.adjustments,
    keywords = this.keywords,
    minusKeywords = this.minusKeywords,
    socdem = this.socdem,
    deviceTypes = this.deviceTypes,
    videosAreNonSkippable = this.videosAreNonSkippable,
    catalogIds = this.catalogIds,
    brandSurveyId = this.brandSurveyId,
    showsFrequencyLimit = this.showsFrequencyLimit,
    cpmAssets = this.cpmAssets,
    campaignMeasurers = this.campaignMeasurers,
    uacBrandsafety = this.uacBrandsafety,
    uacDisabledPlaces = this.uacDisabledPlaces,
    relevanceMatch = this.relevanceMatch,
    retargetingCondition = this.retargetingCondition,
    assetLinks = this.assetLinks,
    adGroupIds = this.adGroupIds?.toList(),
    isCpmBrief = this.advType == AdvType.CPM_BANNER,
)
