package ru.yandex.direct.core.entity.uac.converter

import org.slf4j.LoggerFactory
import ru.yandex.direct.core.entity.client.service.ClientGeoService
import ru.yandex.direct.core.entity.region.RegionDesc
import ru.yandex.direct.i18n.Language
import ru.yandex.direct.regions.GeoTree
import ru.yandex.direct.core.entity.uac.getCurrentLanguage


object UacRegionNamesConverter {

    private val logger = LoggerFactory.getLogger(UacRegionNamesConverter::class.java)

    fun regionIdsToNames(geoTree: GeoTree, regionIds: List<Long>): List<String> {
        val language = getCurrentLanguage()
        return regionIds.mapNotNull { getRegionName(geoTree, it, language) }
    }

    private fun getRegionName(geoTree: GeoTree, regionId: Long, language: Language): String? {
        val region = geoTree.getRegion(regionId)
        if (region == null) {
            logger.error("unknown region $regionId")
            return null
        }
        val regionDesc = RegionDesc.fromRegion(region)
        return ClientGeoService.getRegionName(regionDesc, language)
    }
}
