package ru.yandex.direct.core.entity.uac.grut

import javax.naming.OperationNotSupportedException
import ru.yandex.grut.client.GrutClient
import ru.yandex.grut.client.GrutClientBase
import ru.yandex.grut.client.GrutTransaction

class RequestScopeGrutContext(private val grutClient: GrutClient) : GrutContext() {
    private var grutTransaction: GrutTransaction? = null
    override fun setTransaction(grutTransaction: GrutTransaction) {
        this.grutTransaction = grutTransaction
    }

    override val client: GrutClientBase
        get() = grutTransaction ?: grutClient

    override fun reset() {
        grutTransaction = null
    }

    override fun transactional() = grutTransaction != null
}

class ThreadLocalGrutContext(private val grutClient: GrutClient) : GrutContext() {
    private val localGrutTransaction: ThreadLocal<GrutTransaction> = ThreadLocal()
    override fun setTransaction(grutTransaction: GrutTransaction) {
        localGrutTransaction.set(grutTransaction)
    }

    override val client: GrutClientBase
        get() = localGrutTransaction.get() ?: grutClient

    override fun reset() {
        localGrutTransaction.remove()
    }

    override fun transactional() = localGrutTransaction.get() != null
}

/**
 * Контекст для тех приложений, которые не используют grut
 */
class EmptyGrutContext : GrutContext() {
    override fun setTransaction(grutTransaction: GrutTransaction) {
        throw OperationNotSupportedException("No operations in empty context")
    }

    override val client: GrutClientBase
        get() = throw OperationNotSupportedException("No operations in empty context")

    override fun reset() {
        throw throw OperationNotSupportedException("No operations in empty context")
    }

    override fun transactional(): Boolean {
        throw throw OperationNotSupportedException("No operations in empty context")
    }

}

class NonTransactionalGrutContext(
    grutClient: GrutClient
) : GrutContext() {

    override val client = grutClient

    override fun setTransaction(grutTransaction: GrutTransaction) {
        throw OperationNotSupportedException("No operations in empty context")
    }

    override fun reset() {
        throw OperationNotSupportedException("No operations in empty context")
    }

    override fun transactional(): Boolean {
        throw OperationNotSupportedException("No operations in empty context")
    }
}

abstract class GrutContext {
    internal abstract fun setTransaction(grutTransaction: GrutTransaction)
    abstract val client: GrutClientBase
    abstract fun reset()
    abstract fun transactional(): Boolean
}
