package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue

enum class AdvType(val id: Int) {
    /**
     * РМП кампании
     */
    MOBILE_CONTENT(1),

    /**
     * UC кампании
     */
    TEXT(2),

    /**
     * cpm_banner кампании
     */
    CPM_BANNER(3),

    ;

    companion object {
        fun fromId(id: Int): AdvType {
            return values().first { it.id == id }
        }

        fun fromName(name: String): AdvType {
            return values().first { it.name == name}
        }
    }

    @JsonValue
    open fun getAdvType() = name.lowercase()
}
