package ru.yandex.direct.core.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.direct.core.entity.bidmodifier.AgeType

enum class AgePoint(override val goalId: Long, override val order: Int) : SocdemGoal {
    AGE_0(2499000003, 0),
    AGE_18(2499000004, 1),
    AGE_25(2499000005, 2),
    AGE_35(2499000006, 3),
    AGE_45(2499000007, 4),
    AGE_55(2499000008, 5),
    AGE_INF(Long.MAX_VALUE, 6)
    ;

    @JsonValue
    open fun getAgePoint() = name.toLowerCase()

    fun getUpperIntervalUnderAgePoint(): AgeType {
        return when (this) {
            AGE_18 -> AgeType._0_17
            AGE_25 -> AgeType._18_24
            AGE_35 -> AgeType._25_34
            AGE_45 -> AgeType._35_44
            AGE_55 -> AgeType._45_54
            AGE_INF -> AgeType._55_
            else -> AgeType.UNKNOWN
        }
    }

    fun getLowerIntervalAboveAgePoint(): AgeType {
        return values()
            .filter { it.ordinal == 1 + this.ordinal }
            .map { it.getUpperIntervalUnderAgePoint() }
            .firstOrNull() ?: AgeType.UNKNOWN
    }
}
